[![Codacy Badge](https://api.codacy.com/project/badge/Grade/fab2ab1768a44e86bc555bb695d80584)](https://www.codacy.com/manual/HLSiira/Atheos?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=HLSiira/Atheos&amp;utm_campaign=Badge_Grade)

# Atheos Web IDE, updated from [Codiad](http://codiad.com/)

![Screenshot: Atheos](/docs/atheos.png?raw=true "Atheos")

Atheos is an updated and currently maintained fork of Codiad, a web-based IDE framework with a small footprint and minimal requirements. 

Codiad was built with simplicity in mind, allowing for fast, interactive development without the massive overhead of some of the larger desktop editors. That being said even users of IDE's such as Eclipse, NetBeans and Aptana are finding Codiad's simplicity to be a huge benefit. While simplicity was key, we didn't skimp on features and have a team of dedicated developer actively adding more.

Atheos is expanding on that mentality as much as possible, trying to minimizing it's footprint even further while maximizing functionality and performance. The major goal of Atheos will be a complete rewrite of every line of code, from the bottom to the top, including plugins.

For more information on the project please check out the **[check out the Wiki](https://github.com/HLSiira/Atheos/wiki)** or **[the Atheos Website](http://www.atheos.io)**

## ~~Un~~ Maintained Status:

Atheos is Codiad to its core, however Atheos will be updated to use all the latest versions of libraries used if possible. Where not possible, newer libraries will replace older libraries. The UI has been given a new flat look, Font Awesome Icons in place of EnTypo, and the SVGs used in the file manager have been replaced with a smaller web font. Both the Front and Back ends are slowly being rebuilt with more performant, and smaller functions.

## RoadMap:
01. Update all dependendencies:
    - Ace Editor has been updated, but it needs optimization / cleaning.
    - jQuery is actually so out of date thait's easier to remove it completely in favor of a smaller library.
02. Standardize all modules/components:
    - As Codiad grew, new features and standards were added but not back dated to older established functions.
04. Modify everything to meet best practices, SEO and accessabilty standards.
    - Make everything pretty, new icons, cleaner design, better ingredients.
    - Accessability is going to be a hard one to tackle and might be a long term goal unless an expert drops in.

| ## | Planned goals & features (No order)                       |
|----|-----------------------------------------------------------|
| 01 | Address all open issues on original Codaid Repo           |
| 02 | Updated Market place to be more flexible / informative    |
| 03 | Fix / update plugins on Market place                      |
| 04 | Update all the themes Codaid has                          |
| 05 | In-Browser Theme Support                                  |
| 06 | Reduce client requests as much as possible                |
| 07 | Autosave / caching functions for file changes             |
| 08 | Establish better Wiki pages outside of Github Wiki        |
